/*
   CREATE REINDEX.PRG
   This program is designed to do what the version that
   Romain once did does -- it creates a program for you
   that will re-build your index tags on your tables --
   but this one uses some special features of Visual dBASE 7
   to do it ...

   This will create a single program file that should regenerate
   your index tags for all tables (after deleting them) -- 
   if you add a table, or add a new index tag, or change an 
   index tag definition, you should re-run this routine!

   // NOTE: If anyone has suggestions for improvements, 
   // feel free to contact me. This is something I threw
   // together in about an hour of tinkering ...

   08/23/1998 -- added addition of a try/catch around
                 the DROP INDEX command, to catch
                 an error if the index tag doesn't
                 exist ... this adds heavily to the 
                 length of the code, because the try/catch
                 is created for *each* index tag that
                 we attempt to drop, but it should
                 avoid the user being interrupted
                 by an error that won't stop the
                 program from doing it's job ...

*/

close tables // just to be sure none are open ...

// load table info into an array
aTables = new Array()
aTables.dirExt( "*.dbf" )

// check to see if we're wasting our time:
if aLen( aTables, 1 ) = 0
   msgbox( "There are no .DBF tables in this directory!",;
           "Nothing to do", 64)
   return
endif

// resize the array so it has only one column,
// that being the names of the tables:
nRows = aLen( aTables,1 )
aTables.resize( nRows, 1, 1)
// sort it ...
aTables.sort()

// create file object:
fProgram = new File()
// should just overwrite one if it exists
fProgram.create( "rebuild indexes.prg", "W" )
// Store some basic stuff into beginning of program:
cOutString = "/*"
fProgram.puts( cOutString )
cOutString = "   REBUILD INDEXES.PRG"
fProgram.puts( cOutString )
cOutString = "   Program Generated by 'create index.prg'"
fProgram.puts( cOutString )
cOutString = "   "+date()
fProgram.puts( cOutString )
cOutString = "   This will delete index tags and rebuild from"
fProgram.puts( cOutString )
cOutString = "   scratch ..."
fProgram.puts( cOutString )
cOutString = "*/"
fProgram.puts( cOutString )
cOutString = ""
fProgram.puts( cOutString )
cOutString = "close tables   // Will close tables just to be safe"
fProgram.puts( cOutString )
cOutString = ""
fProgram.puts( cOutString )
cOutString = "set procedure to message.wfm additive"
fProgram.puts( cOutString )
cOutString = "fMessage = new MessageForm()"
fProgram.puts( cOutString )
cOutString = "fMessage.text = 'Processing Tables'"
fProgram.puts( cOutString )
cOutString = "fMessage.title.text = 'Recreating index tags'"
fProgram.puts( cOutString )
cOutString = "fMessage.open()"
fProgram.puts( cOutString )
// add a blank line
cOutString = ""
fProgram.puts( cOutString )

// open a message dialog to show user something's
// happening:
set procedure to message.wfm additive
fMessage = new MessageForm()
fMessage.text         := "Processing tables"
fMessage.title.text   := "Getting index tags"
fMessage.message.text := aTables[ 1 ]
fMessage.Open()

// now, do it!
for tableNumber = 1 to aLen( aTables, 1 )
    // Display information in message form:
    fMessage.message.text := upper( aTables[ tableNumber ] )

    // Instance of TableDef object
    tTable = new TableDef() // undocumented feature
    // Give it the table name to use
    tTable.tableName := aTables[tableNumber]
    // Load the table
    tTable.load()

    // shorten coding a bit:
    cTableName = aTables[ tableNumber ]
    // output name of table and message instructions ...
    cOutString = "   // -- "+cTableName
    fProgram.puts( cOutString )
    cOutString = "   fMessage.message.text = '"+upper(cTableName)+"'"
    fProgram.puts( cOutString )
    cOutString = "   fMessage.repaint()"
    fProgram.puts( cOutString )

    // Loop through index tags, if any. 
    if tTable.indexes.size > 0

       for indexNumber = 1 to tTable.indexes.size

           // add a try/catch to this thing:
           cOutString = "   try"
           fProgram.puts( cOutString )

           // create command to delete the index tag
           // NOTE: added quote around index Tag name -- solves
           // problem with tags that use reserved SQL keywords,
           // such as 'group' as the tag name. 1/23/98
           cOutString = "      drop index '"+cTableName+"'.'"+;
                        tTable.indexes[ indexNumber ].indexName+"'"
           fProgram.puts( cOutString )

           // catch:
           cOutString = "   catch (dbException e)"
           fProgram.puts( cOutString )
           // if the error isn't 239, display it ... otherwise
           // we're ignoring it
           cOutString = "      if e.code # 239 // index does not exist" 
           fProgram.puts( cOutString )
           cOutString = "         msgbox( 'Error: '+e.code+chr(13)+e.message )"
           fProgram.puts( cOutString )
           cOutString = "      endif"
           fProgram.puts( cOutString )
           cOutString = "   endtry"
           fProgram.puts( cOutString )
           cOutString = "" // blank line
           fProgram.puts( cOutString )
       next
    else
       cOutString = "   // No Indexes to Process"
       fProgram.puts( cOutString )
    endif

    // at this point there should be no index tags and hence
    // no .MDX file. Next, we need to rebuild ...
    // are there any index tags in the first place?
    if tTable.indexes.size > 0
       cOutString = "   // rebuild index tags ..."
       fProgram.puts( cOutString )
       cOutString = "   d = new DBFIndex() // undocumented feature"
       fProgram.puts( cOutString )
       
       for indexNumber = 1 to tTable.indexes.size
           cOutString = "   // index tag: "+tTable.indexes[ indexNumber ].indexName
           fProgram.puts( cOutString )
           cOutString = "   d.expression    := '"+tTable.indexes[ indexNumber ].expression+"'"
           fProgram.puts( cOutString )
           cOutString = "   d.descending    := "+tTable.indexes[ indexNumber ].descending
           fProgram.puts( cOutString )
           cOutString = "   d.unique        := "+tTable.indexes[ indexNumber ].unique
           fProgram.puts( cOutString )
           cOutString = "   d.forExpression := '"+tTable.indexes[ indexNumber ].forExpression+"'"
           fProgram.puts( cOutString )
           cOutString = "   d.indexName     := '"+tTable.indexes[ indexNumber ].indexName+"'"
           fProgram.puts( cOutString )
           // another undocumented feature:
           cOutString = "   _app.databases[1].createIndex( '"+cTableName+"', d ) // create it"
           fProgram.puts( cOutString )
       next // indexNumber
    endif

    cOutString = ""
    fProgram.puts( cOutString )
next

// the rest ... (cleanup ...)
cOutString = ""
fProgram.puts( cOutString )
cOutString = "fMessage.release()"
fProgram.puts( cOutString )
cOutString = ""
fProgram.puts( cOutString )
cOutString = "/* -- End of Program: REBUILD INDEXES.PRG   */"
fProgram.puts( cOutString )

// cleanup
fProgram.close()
fMessage.release()
msgbox( "Done!","Finished!",64)

/* 
    -- End of Program: CREATE REINDEX.PRG --
*/
