/* 
   INDEXQRY.CC
   06/07/1998
   Ken Mayer
   Based on a suggestion by Romain Strieff
   7/8/1998 -- added Romain's GetTableName call ...

   A custom query class with a "selIndex()" method.
   This requires that we have a tableDef that loads
   the table in use, and scans through the index names ...

   Note that this file has two classes: the query (IndexQry)
   and a form (IndexQryForm)

   Usage:
      set procedure to IndexQry.cc additive
      q = new IndexQry()
      q.sql = "select * from 'MyTable'"
      q.active = true
      // so far, just like a normal query, you can also 
      // assign a database before the active statement
      q.rowset.selIndex() // blank will bring up a form
         OR
      q.rowset.selIndex("MyIndex") // will attempt to find it,
                             // and if found, will set it ...

   NOTE: This code always sets the query at the top of
   the rowset (this.rowset.first() ) -- there are two
   places it does this -- if you would rather it didn't,
   simply comment them out ...

*/

class IndexQry of QUERY custom

   Procedure execute
     // override the execute method

     // we really do need to call the super-class's method:
     super::execute()

     // get tableName:
     cName = this.GetTableName()
     if empty( cName )
        msgbox( "Error -- invalid table name" )
        return
     endif

     // setup a tableDef:
     this.t = new TableDef()
     this.t.tableName   := cName
     this.t.database    := this.database
     this.t.load()
     this.rowset.indexFlag = iif( this.t.indexes.size > 0, true, false )

     // Assign method to rowset:
     this.rowset.selIndex = class::SelIndex

   Procedure SelIndex( cIndexName )
     // here's the new method

     if this.rowset.indexFlag
        // if no indexName passed, we must
        // assume the user wants to _select_ an
        // index tag from a list:
        if empty( cIndexName )
           fQry = new IndexQryForm()
           fQry.Indexes = new Array()
           // Load array used in form for listbox:
           fQry.Indexes.add( "<No Index>" )
           for i = 1 to this.t.indexes.size
               fQry.Indexes.Add( this.t.indexes[i].indexName )
           next
           fQry.indexes.sort()
           fQry.indexListBox.dataSource := "array fQry.indexes"
           fQry.indexListBox.curSel     := 1
           // Open it!
           fQry.ReadModal()

           // set it!
           if fQry.indexListBox.value == "<No Index>"
              this.rowset.indexName := ""
           else
              this.rowset.indexName := fQry.indexListBox.value                     
           endif
           this.rowset.first()

        else
           // let's try to find it ...
           this.rowset.indexName := "" // empty it out
           for i = 1 to this.parent.t.indexes.size
               if upper(cIndexName) == upper( this.t.indexes[i].indexName )
                  this.rowset.indexName := cIndexName
                  this.rowset.first()
                  exit
               endif
           next

           // if the indexName is still empty:
           if empty( this.rowset.indexName )
              msgbox( "Could not find indexName: "+cIndexName+"." )
           endif
             
        endif // empty( cIndexName )
     else
        // Let user know somewhere there's a mistake ... <G>
        msgbox( "There are no indexes for this table" )
     endif

   // Romain's code to get the tableName from the query
   // -- this uses the BDE API:  
   function GetTableName
      local cRet
      cRet = ""
      if type( "GetTableNameFromQueryHandle" ) # "FP"
         extern cInt GetTableNameFromQueryHandle (cHandle, cString);
               IDAPI32 from "DbiGetCursorProps"
      endif
      nH = this.rowset.handle
      c=space(2048)
      if (GetTableNameFromQueryHandle( nH, c) == 0)
         cRet = c.left(255).lefttrim()
      endif

   return cRet

endclass
// end of class: INDEQRY()

// form used above:
class indexqryForm of FORM
   with (this)
      scaleFontBold = false
      height = 11
      left = 31.2857
      top = 4.9545
      width = 40
      text = "Select index for data"
      clientEdge = true
      topMost = true
      autoCenter = true
      mdi = false
      smallTitle = true
      sizeable = false
      escExit = false
      maximize = false
      minimize = false
   endwith


   this.INDEXLISTBOX = new LISTBOX(this)
   with (this.INDEXLISTBOX)
      height = 5.7727
      left = 1.8571
      top = 0.8182
      width = 35.5714
      id = 101
      colorHighLight = "white/blue"
   endwith


   this.TEXTEXPL = new TEXT(this)
   with (this.TEXTEXPL)
      height = 2.1818
      left = 2.5714
      top = 6.9545
      width = 34.1429
      border = true
      fontSize = 8
      fontItalic = true
      text = "Select the index you wish to use. When you click the button below, whatever index you have chosen will take effect on your table."
      borderStyle = 10	// Etched Out
   endwith


   this.DONEPUSHBUTTON = new PUSHBUTTON(this)
   with (this.DONEPUSHBUTTON)
      height = 1.0909
      left = 17.2857
      top = 9.4091
      width = 4.7143
      text = ""
      default = true
      upBitmap = "RESOURCE #1005"
      downBitmap = "RESOURCE #1006"
      speedTip = "Done"
      value = false
      onClick = {; form.close() }
   endwith

endclass

/*
   end of file: indexqry.cc
*/


