/*
   ----------------------------------------------------------------
    Program...: SHOW2.PRG
    Programmer: Ken Mayer
    Date......: 10/29/1998
    Notes.....: Designed to show the contents of a multi-column 
                array. Don't use this on a single-dimension 
                array -- the memvar nColumns will return '0', 
                and the loops will not display anything.
                Note: the display here could get 'messy', 
                depending on the types of data contained in 
                your arrays. This is mostly here for example 
                purposes, and can't possibly anticipate all 
                variations ... you might want to copy it and 
                make changes as you need ...
    Usage.....: do show2 with aMyArray
   ----------------------------------------------------------------------
*/
    parameter oArray
    if type( "oArray" ) # "A"
       ? "Not an array!"
       return
    endif

    nRows    = oArray.subscript( oArray.size, 1)
    nColumns = oArray.subscript( oArray.size, 2)
    // display column headers
    for nColumn = 1 to nColumns
        // assumes that each column will contain < 25 characters
        ?? "Column "+nColumn at (20*(nColumn-1))+7
    next

    // display items in each row for each column
    for nRow = 1 to nRows
        // row header
        ? "Row "+nRow
        for nColumn = 1 to nColumns
            // actual element to be displayed
            ?? oArray[nRow,nColumn]  at (20*(nColumn-1))+7
        next
    next
   
// EoP: SHOW2.PRG