/*
    FROMUNIX.PRG
    A simple program using two file objects to read
    a file with "LF" (line feed) as the end of line
    character -- DOS/Windows prefer "CR/LF" (Carriage
    Return and Line Feed). 

    This is an example provided with FILEOBJECT.HOW
    by Ken Mayer

    The file "README.UNX" was created by Gary White -- it
    is the first few lines of the Visual dBASE 7 "README.TXT"
    file, with the carriage return character stripped out.

    **** Very Important: do NOT load this file (readme.unx) 
    into an editor and save any chances or it will 
    automatically be saved out with the CR/LF ...

    Note that the first 'gets()' here limits the number of
    characters to read to 1,000. If the first line is
    1,000 characters, then the chances are very good that
    the CR/LF doesn't exist ... you may need to modify this
    based on your own input file ...
*/

/* 
   You might want to modify this to have a parameter asking
   for the name of the file to be translated, check to see
   if the file exists, copy it to a backup, etc.

   The code could look like the following -- uncomment it, and
   make changes to the files used in the open/create below:

   parameter cInFile

   if pCount() < 1
      msgbox( "Need a filename to process!", "Can't do it!", 16 )
      return
   endif

   if not file( cInFile )
      msgbox( "File does not exist!", "Can't do it!", 16 )
      return
   endif

   cBackupFile = cInFile+"2" // add a '2' to end of filename
   copy file (cInFile) to (cBackupFile)
*/
fReadIt = new File()
fReadIt.Open( "readme.unx", "R" )
fWriteIt = new File()
fWriteIt.Create( "readme.dos", "A" )

// Check to see how long the first line
// of the file is:
cString = fReadIt.readLn( 1000 ) // 1,000 characters, or to CR/LF,
                               // or in the case of a small file,
                               // the eof ...
nLength = cString.length
fReadIt.seek( 0 ) // back to the top of the file

// if the first line is wider than 80 characters,
// we need to convert this file ...
nLines = 0
if nLength > 80 
   do while not fReadIt.eof()          // loop
      // 10000 = an arbitrarily large value for the 
      // number of characters to read
      // chr( 0x0A ) = the Line Feed character -- information
      // for these is in online help
      cString = fReadIt.readLn( 10000, chr( 0x0A ) )
                           // read a line to the Line Feed
                           // this places the position pointer
                           // on the next line ...
      // the writeLn method writes out the CR/LF automatically:
      fWriteIt.writeLn( cString )
      nLines++
// *******
// for a large file, you might want to create a message
// form that displays how many lines converted ...
// *******
   enddo
else
   ? "No need to convert the file!"
endif
fReadIt.close()
fWriteIt.close()
? nLines+" lines converted to file 'readme.dos'"

