/*
    TOTABLE.PRG
    A program that reads a "data" file with pipe symbols
    as the separator between the fields, and stores them
    to a table (appends a row, etc.).

*/
   // Delete table if it exists:
   if file( "testconvert.dbf" )
      drop table testconvert
   endif

   // Create table:
   create table "testConvert" ( ;
       "testConvert"."First Name" character( 20 ),;
       "testConvert"."Last Name"  character( 20 ),;
       "testConvert"."Address1"   character( 30 ),;
       "testConvert"."Address2"   character( 30 ),;
       "testConvert"."City"       character( 20 ),;
       "testConvert"."State"      character( 2 ),;
       "testConvert"."PostalCode" character( 10 ),;
       "testConvert"."Phone"      character( 14 ) )

   // instantiate file object:
   f = new File()
   f.open( "somedata.txt", "R" )

   // instantiate query:
   q = new Query()
   q.sql = "select * from testConvert"
   q.active := true

   // shortcut to fields array:
   fFields = q.rowset.fields

   // start the loop:
   nRows = 0
   do while not f.eof()

      // read a line:
      cLine = f.gets()
      q.rowset.beginAppend()

      // start parsing ...
      cString = ""
      nPipe = 0 // number of pipes found
      for i = 1 to cLine.length

          cChar = cLine.substring( i-1, i ) // current character
          if ( cChar # "|" ) and ( i < cLine.length ) // it's not a pipe symbol
             cString += cChar // add current character to string
          else // it IS a pipe symbol or last character in line
             if cChar # "|"      // it's the last character in the line
                cString += cChar // add to end of field
             endif
             nPipe++ 
             fFields[ nPipe ].value := cString
             cString = "" // blank it out again
          endif

      next // end of parsing

      // save the row:
      q.rowset.save()
      nRows++
   enddo
   f.close()
   q.active := false

   ? nRows+" rows saved to table"

/*
   End of Program: toTable.prg
*/
