/*
	This is just a "proof of concept" demonstration of attaching a toolbar to 
   _app.framewin.  This is not expected to be plug and play code. Among other 
   things, exit code simply issues a "close forms" and does very little 
   clean-up. There's virtually NO error checking.  And, of course, there's 
   the matter of all we're doing is opening multiple copies of the same form. <G>

   Try this and open 3 copies of the form.  Use the navigation buttons to
   navigate to the last row in one form, then click on another form and navigate
   in it such that you're not on either the first, or last record.  Now, click 
   on the different forms and see how the onUpdate code handles enabling and 
   disabling the buttons.

         Enjoy,
         Gary White
         November 20, 1998
*/

set procedure to						// clear any lurking code
set procedure to program(1)		// make the onUpdate code available
_app.speedbar = false				// turn off the built-in toolbar
do appmenu with _app.framewin		// call our menu whose code follows the toolbar
_app.toolbar = new myToolbar()	// create our toolbar
_app.toolbar.attach(_app.framewin)	// and attach it to _app.framewin
// initialize some variables
_app.activeForm = null				// a property to track which form has focus
_app.lastX = 0							// create a couple of properties so our forms
_app.lastY = 0							//     don't open on top of one another
_app.formsOpened = 0
shell(false)							// turn of navigator and command window
return

class myToolbar of toolbar
   this.onUpdate = class::myToolBar_onUpdate

   this.firstButton = new toolButton( this )
   with ( this.firstButton )
        bitmap   = "resource #851"
        speedTip = "First Row"
        onClick  = {;_app.activeForm.rowset.first()}
   endwith

   this.previousButton = new toolButton( this )
   with ( this.previousButton )
        bitmap   = "resource #853"
        speedTip = "Previous Row"
        onClick  = {;_app.activeForm.rowset.next(-1)}
   endwith

   this.nextButton = new toolButton( this )
   with ( this.nextButton )
        bitmap   = "resource #854"
        speedTip = "Next Row"
        onClick  = {;_app.activeForm.rowset.next()}
   endwith

   this.lastButton = new toolButton( this )
   with ( this.lastButton )
        bitmap   = "resource #856"
        speedTip = "Last Row"
        onClick  = {;_app.activeForm.rowset.last()}
   endwith

   function myToolBar_onUpdate
      local bRowset, bAtFirst, bAtLast
      bAtFirst = false	// initialize our variables
      bAtLast = false
      bRowset = false
      if type("_app.activeForm") # null
         bRowset := type( "_app.activeForm.rowset" ) == "O" 
         if bRowset 
            bAtFirst := _app.activeForm.rowset.atFirst()
            bAtLast := _app.activeForm.rowset.atLast()
            this.firstButton.enabled := NOT bAtFirst
            this.previousButton.enabled := NOT bAtFirst
            this.nextButton.enabled := NOT bAtLast
            this.lastButton.enabled := NOT bAtLast
         else
            this.firstButton.enabled := false
            this.previousButton.enabled := false
            this.nextButton.enabled := false
            this.lastButton.enabled := false
         endif
      endif
   return

endclass

procedure appmenu
parameter formObj
new appmenuMENU(formObj, "root")

class appmenuMENU(formObj, name) of MENUBAR(formObj, name)

   this.FILE = new MENU(this)
   with (this.FILE)
      text = "&File"
   endwith

   this.FILE.OPEN = new MENU(this.FILE)
   with (this.FILE.OPEN)
      onClick = class::OPEN_ONCLICK
      text = "&Open"
   endwith

   this.FILE.CLOSE = new MENU(this.FILE)
   with (this.FILE.CLOSE)
      onClick = class::CLOSE_ONCLICK
      text = "&Close"
   endwith

   this.FILE.EXIT = new MENU(this.FILE)
   with (this.FILE.EXIT)
      onClick = class::EXIT_ONCLICK
      text = "E&xit"
   endwith

   this.Window = new MENU(this)
   with (this.Window)
      text = "&Window"
   endwith

   this.windowMenu = this.Window

   function CLOSE_onClick
      if type("_app.activeForm") == "O" and _app.activeForm.hWnd # 0
         _app.activeForm.release()
      endif
      return

   function EXIT_onClick
      if type("_app.toolbar") == "O" and _app.toolbar.hWnd # 0
         _app.toolbar.detach(_app.framewin)
      endif
      close forms
      _app.toolbar := null
      _app.speedbar := true
      shell( true, true )
      return

   function OPEN_onClick
      local f
      f = new appForm()
      f.top := _app.lastY
      f.left := _app.lastX
      _app.lastX += 5
      _app.lastY ++
      _app.formsOpened ++
      f.text = f.text + _app.formsOpened
      f.open()
      return

endclass

class appForm of form
   with (this)
      height = 5
      width = 43
      text = "FishForm "
		onGotFocus = {;_app.activeForm = this}
   	onLostFocus = {;_app.activeForm = null}
	endwith

   this.DATABASE1 = new DATABASE()
   this.DATABASE1.parent = this
   with (this.DATABASE1)
      left = 3.1429
      top = 0.7273
      databaseName = "VDBSAMPLE"
      active = true
   endwith

   this.QUERY1 = new QUERY()
   this.QUERY1.parent = this
   with (this.QUERY1)
      left = 7.8571
      top = 0.7727
      database = form.database1
      sql = "select * from fish.dbf"
      active = true
   endwith

   this.TEXTNAME1 = new TEXT(this)
   with (this.TEXTNAME1)
      height = 1
      left = 1
      top = 2
      width = 5
      wrap = false
      alignVertical = 1	// Middle
      fontSize = 8
      text = "Name"
   endwith

   this.ENTRYFIELDNAME1 = new ENTRYFIELD(this)
   with (this.ENTRYFIELDNAME1)
      dataLink = form.query1.rowset.fields["Name"]
      height = 1
      left = 7
      top = 2
      width = 32
      fontName = "MS Sans Serif"
   endwith

   this.rowset := this.query1.rowset
endclass
