/*
    MYTOOLBAR.CC
    A toolbar class with a "standard" set of 
    toolbuttons.

    To use this you must instantiate your form
    (in other words, you cannot call the form
    with DO MYFORM.WFM, instead you must use
    code like below), and then you must attach
    the toolbar to the form:

    set procedure to myform.wfm additive
    set procedure to mytoolbar.cc additive
    f = new myformForm()
    t = new mytoolbar()
    t.attach( f )

    // depending on how you need to instantiate the form:
    f.mdi = true // default to Multiple document interface
    f.open()

    // or:
    f.mdi = false // Single-document interface
    f.open()

    // or:
    f.mdi = false // single document
    f.readModal() // modal dialog form


    // WARNING, after closing the form, you should detach
    // the toolbar:
    f.close()
    t.detach( f )

*/

class myToolbar of toolbar
   // properties go here
   this.flat         = true
   this.floating     = false
   this.onUpdate     = class::MyToolBar_onUpdate

   // definition of toolbuttons go here
   this.FirstToolButton = new ToolButton( this )
   with ( this.FirstToolButton )
        bitmap   := "RESOURCE TS_FIRST"
        speedTip := "First Row"
        onClick  := class::First_onClick
   endwith

   this.PreviousToolButton = new ToolButton( this )
   with ( this.PreviousToolButton )
        bitmap   := "RESOURCE TS_PREV"
        speedTip := "Previous Row"
        onClick  := class::Previous_onClick
   endwith

   this.NextToolButton = new ToolButton( this )
   with ( this.NextToolButton )
        bitmap   := "RESOURCE TS_NEXT"
        speedTip := "Next Row"
        onClick  := class::Next_onClick
   endwith

   this.LastToolButton = new ToolButton( this )
   with ( this.LastToolButton )
        bitmap   := "RESOURCE TS_LAST"
        speedTip := "Last Row"
        onClick  := class::Last_onClick
   endwith

   this.Separator1ToolButton = new ToolButton( this )
   with ( this.Separator1ToolButton )
        separator = true
   endwith

   // -- Edit buttons:
   this.CutToolButton = new ToolButton( this )
   with ( this.CutToolButton )
        bitmap   := "RESOURCE TS_CUT"
        speedTip := "Cut"
        onClick  := class::Cut_onClick
   endwith

   this.CopyToolButton = new ToolButton( this )
   with ( this.CopyToolButton )
        bitmap   := "RESOURCE TS_COPY"
        speedTip := "Copy"
        onClick  := class::Copy_onClick
   endwith

   this.PasteToolButton = new ToolButton( this )
   with ( this.PasteToolButton )
        bitmap   := "RESOURCE TS_PASTE"
        speedTip := "Paste"
        onClick  := class::Paste_onClick
   endwith

   this.Separator2ToolButton = new ToolButton( this )
   with ( this.Separator2ToolButton )
        separator = true
   endwith

   // -- Rowset Editing buttons
   this.EditToolbutton = new ToolButton( this )
   with ( this.EditToolButton )
        bitmap   := "RESOURCE TS_EDIT"
        speedTip := "Edit Row"
        onClick  := class::Edit_onClick
   endwith

   this.AppendToolbutton = new ToolButton( this )
   with ( this.AppendToolButton )
        bitmap   := "RESOURCE TS_APPEND"
        speedTip := "Add Row"
        onClick  := class::Append_onClick
   endwith

   this.DeleteToolButton = new ToolButton( this )
   with ( this.DeleteToolButton )
        bitmap   := "RESOURCE TS_DELETE"
        speedTip := "Delete Row"
        onClick  := class::Delete_onClick
   endwith
   
   this.SaveToolButton = new ToolButton( this )
   with ( this.SaveToolButton )
        bitmap   := "RESOURCE TS_SAVE"
        speedTip := "Save Row"
        onClick  := class::Save_onClick
   endwith

   this.AbandonToolButton = new ToolButton( this )
   with ( this.AbandonToolButton )
        bitmap   := "RESOURCE TS_ABANDON"
        speedTip := "Abandon Row"
        onClick  := class::Abandon_onClick
   endwith

   function MyToolBar_onUpdate

      // check to see if there is a rowset on the form:
      local bRowset, bAtFirst, bAtLast
      bRowset = type( "this.form.rowset" ) == "O" 
      if bRowset 
         bAtFirst = this.form.rowset.atFirst()
         bAtLast  = this.form.rowset.atLast()
         this.FirstToolbutton.enabled    := NOT bAtFirst
         this.PreviousToolbutton.enabled := NOT bAtFirst
         this.NextToolbutton.enabled     := NOT bAtLast
         this.LastToolbutton.enabled     := NOT bAtLast
         bClip = ( TYPE("this.form.activeControl.copy") == "FP" )
         this.CutToolButton.enabled      := bClip
         this.CopyToolButton.enabled     := bClip
         this.PasteToolButton.enabled    := bClip
         bEoF = this.form.rowset.endOfSet
         this.EditToolButton.enabled     := NOT bEof
         this.AppendToolButton.enabled   := true
         this.DeleteToolButton.enabled   := NOT bEoF
         bModified = this.form.rowset.modified
         this.SaveToolButton.enabled     := bModified
         this.AbandonToolButton.enabled  := bModified

      else // No rowset ...
         this.FirstToolbutton.enabled    := false
         this.PreviousToolbutton.enabled := false
         this.NextToolbutton.enabled     := false
         this.LastToolbutton.enabled     := false
         this.CutToolbutton.enabled      := false
         this.CopyToolbutton.enabled     := false
         this.PasteToolbutton.enabled    := false
         this.EditToolButton.enabled     := false
         this.AppendToolButton.enabled   := false
         this.DeleteToolButton.enabled   := false
         this.SaveToolButton.enabled     := false
         this.AbandonToolButton.enabled  := false
      endif
   return

   // Navigation:
   function First_onClick
   return ( this.parent.form.rowset.first() )

   function Previous_onClick
     local bNext
     // navigate one row "back"
     bNext = this.parent.form.rowset.next(-1)
     // if that didn't work, we're at the endOfSet
     // and need to navigate back to where we were
     if ( not bNext )
         this.parent.form.rowset.next()
      endif
   return

   function Next_onClick
      local bNext
      bNext = this.parent.form.rowset.next()
      if ( not bNext )
         this.parent.form.rowset.next(-1)
      endif
   return ( bNext )

   function Last_onClick
   return ( this.parent.form.rowset.last() )

   // Edit buttons:
   function Cut_onClick
   return ( this.parent.form.activeControl.cut() )

   function Copy_onClick
   return ( this.parent.form.activeControl.copy() )

   function Paste_onClick
   return ( this.parent.form.activeControl.paste() )

   // Rowset edit buttons:
   function Edit_onClick
   return ( this.parent.form.rowset.beginEdit() )

   function Append_onClick
   return ( this.parent.form.rowset.beginAppend() )

   function Delete_onClick
      local bDelete, bFirst
      bDelete = false
      bFirst  = false
      if ( not this.parent.form.rowset.endOfSet )
         if ( MSGBOX("You are about to delete the current row." ;
                   + CHR(13) ;
                   + "Click Yes to delete the current row.", ;
                     "Alert", ;
                     4) == 6 )
            bFirst  := this.parent.form.rowset.atFirst()
            bDelete := this.parent.form.rowset.delete()       
            if ( not bFirst ) 
               this.parent.form.rowset.next(-1)
            endif
            if ( this.parent.form.rowset.endOfSet )
               this.parent.form.rowset.next()
            endif
         endif
      endif
   return ( bDelete )

   function Save_onClick
   return ( this.parent.form.rowset.save() )

   function Abandon_onClick
   return ( this.parent.form.rowset.abandon() )

endclass
