/*
    MYTOOLBAR2.CC
    A toolbar class with a "standard" set of 
    toolbuttons. This one is designed to be
    "attached" to the _app.framewin for MDI 
    applications. This does require that your
    forms all be MDI. (set the MDI property to true)

    In addition, your forms must have the onGotFocus
    event set to let the toolbar know that this
    form is the current form. In the form's onLostFocus
    event, you need to set the toolbar reference to
    "NULL" or it will assume that the form still
    has focus.

    Here is an example set of code for all of this:

    set procedure to myToolBar2.cc additive
    set procedure to MyForm.wfm additive // your form!

    _app.toolbar = new MyToolBar2()
    _app.toolbar.attach( _app.framewin )

    f1 = new MyFormForm()
    f1.mdi = false
    f1.onGotFocus  = {; _app.toolbar.currentForm = this }
    f1.onLostFocus = {; _app.toolbar.currentForm = null }

    // second instance of the same form:
    f2 = new MyFormForm()        
    f2.mdi = false
    f2.onGotFocus  = {; _app.toolbar.currentForm = this }
    f2.onLostFocus = {; _app.toolbar.currentForm = null }

    // open the forms:
    f1.open()
    f2.open()
    f1.setFocus()

    // make sure after you close your forms down, and before
    // you close your application that you detach the 
    // toolbar and null out its reference:
    _app.toolbar.detach( _app.framewin )
    _app.toolbar = null

*/

class myToolbar2 of toolbar

   // properties go here
   this.flat         = true
   this.floating     = false
   this.onUpdate     = class::MyToolBar_onUpdate

   // currentForm is a custom property:
   this.currentForm  = NULL

   // definition of toolbuttons go here
   this.FirstToolButton = new ToolButton( this )
   with ( this.FirstToolButton )
        bitmap   := "RESOURCE TS_FIRST"
        speedTip := "First Row"
        onClick  := class::First_onClick
   endwith

   this.PreviousToolButton = new ToolButton( this )
   with ( this.PreviousToolButton )
        bitmap   := "RESOURCE TS_PREV"
        speedTip := "Previous Row"
        onClick  := class::Previous_onClick
   endwith

   this.NextToolButton = new ToolButton( this )
   with ( this.NextToolButton )
        bitmap   := "RESOURCE TS_NEXT"
        speedTip := "Next Row"
        onClick  := class::Next_onClick
   endwith

   this.LastToolButton = new ToolButton( this )
   with ( this.LastToolButton )
        bitmap   := "RESOURCE TS_LAST"
        speedTip := "Last Row"
        onClick  := class::Last_onClick
   endwith

   this.Separator1ToolButton = new ToolButton( this )
   with ( this.Separator1ToolButton )
        separator = true
   endwith

   // -- Edit buttons:
   this.CutToolButton = new ToolButton( this )
   with ( this.CutToolButton )
        bitmap   := "RESOURCE TS_CUT"
        speedTip := "Cut"
        onClick  := class::Cut_onClick
   endwith

   this.CopyToolButton = new ToolButton( this )
   with ( this.CopyToolButton )
        bitmap   := "RESOURCE TS_COPY"
        speedTip := "Copy"
        onClick  := class::Copy_onClick
   endwith

   this.PasteToolButton = new ToolButton( this )
   with ( this.PasteToolButton )
        bitmap   := "RESOURCE TS_PASTE"
        speedTip := "Paste"
        onClick  := class::Paste_onClick
   endwith

   this.Separator2ToolButton = new ToolButton( this )
   with ( this.Separator2ToolButton )
        separator = true
   endwith

   // -- Rowset Editing buttons
   this.EditToolbutton = new ToolButton( this )
   with ( this.EditToolButton )
        bitmap   := "RESOURCE TS_EDIT"
        speedTip := "Edit Row"
        onClick  := class::Edit_onClick
   endwith

   this.AppendToolbutton = new ToolButton( this )
   with ( this.AppendToolButton )
        bitmap   := "RESOURCE TS_APPEND"
        speedTip := "Add Row"
        onClick  := class::Append_onClick
   endwith

   this.DeleteToolButton = new ToolButton( this )
   with ( this.DeleteToolButton )
        bitmap   := "RESOURCE TS_DELETE"
        speedTip := "Delete Row"
        onClick  := class::Delete_onClick
   endwith
   
   this.SaveToolButton = new ToolButton( this )
   with ( this.SaveToolButton )
        bitmap   := "RESOURCE TS_SAVE"
        speedTip := "Save Row"
        onClick  := class::Save_onClick
   endwith

   this.AbandonToolButton = new ToolButton( this )
   with ( this.AbandonToolButton )
        bitmap   := "RESOURCE TS_ABANDON"
        speedTip := "Abandon Row"
        onClick  := class::Abandon_onClick
   endwith

   function MyToolBar_onUpdate

      // check to see if there is a rowset on the form:
      local bRowset, bAtFirst, bAtLast
      bRowset = type( "this.currentForm.rowset" ) == "O" 
      if bRowset 
         bAtFirst = this.currentForm.rowset.atFirst()
         bAtLast  = this.currentForm.rowset.atLast()
         this.FirstToolbutton.enabled    := NOT bAtFirst
         this.PreviousToolbutton.enabled := NOT bAtFirst
         this.NextToolbutton.enabled     := NOT bAtLast
         this.LastToolbutton.enabled     := NOT bAtLast
         bClip = ( TYPE("this.currentForm.activeControl.copy") == "FP" )
         this.CutToolButton.enabled      := bClip
         this.CopyToolButton.enabled     := bClip
         this.PasteToolButton.enabled    := bClip
         bEoF = this.currentForm.rowset.endOfSet
         this.EditToolButton.enabled     := NOT bEof
         this.AppendToolButton.enabled   := true
         this.DeleteToolButton.enabled   := NOT bEoF
         bModified = this.currentForm.rowset.modified
         this.SaveToolButton.enabled     := bModified
         this.AbandonToolButton.enabled  := bModified

      else // No rowset ...
         this.FirstToolbutton.enabled    := false
         this.PreviousToolbutton.enabled := false
         this.NextToolbutton.enabled     := false
         this.LastToolbutton.enabled     := false
         this.CutToolbutton.enabled      := false
         this.CopyToolbutton.enabled     := false
         this.PasteToolbutton.enabled    := false
         this.EditToolButton.enabled     := false
         this.AppendToolButton.enabled   := false
         this.DeleteToolButton.enabled   := false
         this.SaveToolButton.enabled     := false
         this.AbandonToolButton.enabled  := false
      endif
   return

   // Navigation:
   function First_onClick
   return ( this.parent.currentForm.rowset.first() )

   function Previous_onClick
     local bNext
     // navigate one row "back"
     bNext = this.parent.currentForm.rowset.next(-1)
     // if that didn't work, we're at the endOfSet
     // and need to navigate back to where we were
     if ( not bNext )
         this.parent.currentForm.rowset.next()
      endif
   return

   function Next_onClick
      local bNext
      bNext = this.parent.currentForm.rowset.next()
      if ( not bNext )
         this.parent.currentForm.rowset.next(-1)
      endif
   return ( bNext )

   function Last_onClick
   return ( this.parent.currentForm.rowset.last() )

   // Edit buttons:
   function Cut_onClick
   return ( this.parent.currentForm.activeControl.cut() )

   function Copy_onClick
   return ( this.parent.currentForm.activeControl.copy() )

   function Paste_onClick
   return ( this.parent.currentForm.activeControl.paste() )

   // Rowset edit buttons:
   function Edit_onClick
   return ( this.parent.currentForm.rowset.beginEdit() )

   function Append_onClick
   return ( this.parent.currentForm.rowset.beginAppend() )

   function Delete_onClick
      local bDelete, bFirst
      bDelete = false
      bFirst  = false
      if ( not this.parent.currentForm.rowset.endOfSet )
         if ( MSGBOX("You are about to delete the current row." ;
                   + CHR(13) ;
                   + "Click Yes to delete the current row.", ;
                     "Alert", ;
                     4) == 6 )
            bFirst  := this.parent.currentForm.rowset.atFirst()
            bDelete := this.parent.currentForm.rowset.delete()       
            if ( not bFirst ) 
               this.parent.currentForm.rowset.next(-1)
            endif
            if ( this.parent.currentForm.rowset.endOfSet )
               this.parent.currentForm.rowset.next()
            endif
         endif
      endif
   return ( bDelete )

   function Save_onClick
   return ( this.parent.currentForm.rowset.save() )

   function Abandon_onClick
   return ( this.parent.currentForm.rowset.abandon() )

endclass
